% Author: U. Zlzer
%
%--------------------------------------------------------------------------
% This source code is provided without any warranties as published in 
% DAFX book 2nd edition, copyright Wiley & Sons 2011, available at 
% http://www.dafx.de. It may be used for educational purposes and not 
% for commercial applications without further permission.
%--------------------------------------------------------------------------

% Read input sound file into vector x(n) and sampling frequency FS
[x,FS]=wavread('input filename');
% Sample-by sample algorithm y(n)=a*x(n)
for n=1:length(x), 
     y(n)=a * x(n);
end;
% Write y(n) into output sound file with number of 
% bits Nbits and sampling frequency FS
wavwrite(y,FS,Nbits,'output filename'); 