% so_sdm.m
% Code to produce a second order sdm waveform plot
% now uses the second half of an N-length sine coding
% to let the modulator settle, also plots spectrum
% Mark Sandler 21/7/99

% initial settings
N=10000;
clear y; clear node1; clear node2; clear node3;clear node4;
clear q;
n=[0:N-1];
signal=0.6*sin(10*n*2*pi/N);
q=0;
node5=0;node2=0;node4=0;

% main loop
for i=0:N-1,
q=(node5>0);
node1=signal(i+1)-2*(q-0.5);
node2=node2+node1;
node3=node2-2*(q-0.5);
node4=node3+node5;
% q=(node5>0);
node5=node4;
y(i+1)=q;
end

% plots
figure(1);
subplot(4,1,1);
plot(n(N/2:N-1),signal(N/2:N-1));
subplot(4,1,2)
plot(n(N/2:N-1),y(N/2:N-1),'y');
subplot(4,1,3);
plot(n(N/2:N/2+199),signal(N/2:N/2+199));
subplot(4,1,4)
stem(n(N/2:N/2+199),y(N/2:N/2+199),'y');

[P,F]=spectrum(y,2048,1024,[],1000);
figure(2);
subplot(2,1,1);
plot(F,20*log10(P(:,1)));
xlabel('a) Power Spectrum (Hz) up to half-sampling frequency');
subplot(2,1,2);
plot(F(1:205),20*log10(P(1:205,1)));
xlabel('b) Narrow-band Power Spectrum (Hz)');