% fo_sdm.m
% Code to produce a first order sdm waveform plot
% at the moment there are two versions, depending
% on where the quantization is done, either before
% or after the main sdm loop body
% putting it at the front of the loop seems to make
% sense and is the only thing that makes a second order
% modulator work (Mark Sandler)
clear y; clear node1; clear node2; clear node3;
clear q;
clear qnew; clear qold;
N=10000; n=[0:N-1];
signal=0.6*sin(10*n*2*pi/N);
q=0;
node3=0;
for i=0:N-1,
q=(node3>0);
node1=signal(i+1)-2*(q-0.5);
node2=node1+node3;
node3=node2;
y(i+1)=q;
end

time1=8:0.001:8.999;
time2=8:0.001:8.099;
freq1=0:1:499;
freq2=0:0.01:49.99;
figure(1);
subplot(2,1,1);
plot(time2,signal(8000:8099));
xlabel('(a) One cycle of signal : Time in seconds');
subplot(2,1,2);
stem(time2,y(8000:8099),'b');
xlabel('(b) Modulated signal : Time in seconds');

[P,F]=spectrum(y,2048,1024,[],1000);
figure(2);
subplot(2,1,1);
plot(F,20*log10(P(:,1)+0.00001));
xlabel('a) Power Spectrum (Hz) up to half-sampling frequency');
subplot(2,1,2);
plot(F(1:205),20*log10(P(1:205,1)));
xlabel('b) Narrow-band Power Spectrum (Hz)');

