% VX_stable.m
%===== this program extracts the stable components of a signal
%===== w1 and w2: windows (analysis and synthesis)
%===== WLen: is the length of the windows
%===== n1 and n2: steps (in samples) for the analysis and synthesis

clear; clf

%----- user data -----
test          = 0.4
n1            = 256;
n2            = n1;
WLen          = 2048;
w1            = hanningz(WLen);
w2            = w1;
[DAFx_in, FS] = wavread('redwheel.wav');
L             = length(DAFx_in);
DAFx_in       = [zeros(WLen, 1); DAFx_in; ...
   zeros(WLen-mod(L,n1),1)] / max(abs(DAFx_in));

%----- initializations -----
devcent  = 2*pi*n1/WLen;
vtest    = test*devcent
DAFx_out = zeros(length(DAFx_in),1);
grain    = zeros(WLen,1);
theta1   = zeros(WLen,1);
theta2   = zeros(WLen,1);

tic
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
pin  = 0;
pout = 0;
pend = length(DAFx_in)-WLen;

while pin<pend
    grain = DAFx_in(pin+1:pin+WLen).* w1;
%===========================================
    f      = fft(fftshift(grain));
    theta  = angle(f);
    dev    = princarg(theta-2*theta1+theta2);
%	plot(dev);drawnow;
    ft     = f.*(abs(dev) < vtest);
    grain  = fftshift(real(ifft(ft))).*w2;
    theta2 = theta1;
    theta1 = theta;
% ===========================================
    DAFx_out(pout+1:pout+WLen) = ...
        DAFx_out(pout+1:pout+WLen) + grain;
    pin  = pin + n1;
    pout = pout + n2;
   end
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
toc

%----- listening and saving the output -----
%DAFx_in = DAFx_in(WLen+1:WLen+L);
DAFx_out = DAFx_out(WLen+1:WLen+L) / max(abs(DAFx_out));
soundsc(DAFx_out, FS);
wavwrite(DAFx_out, FS, 'redwheel_stable.wav');