% VX_pv_nothing.m
%===== this program is a simple phase vocoder, with:
%===== w1 and w2 windows (analysis and synthesis)
%===== WLen is the length of the windows
%===== n1 and n2: steps (in samples) for the analysis and synthesis
clear; clf
%----- user data -----
n1            = 512;
n2            = n1;
WLen          = 2048;
w1            = hanningz(WLen);
w2            = w1;
[DAFx_in, FS] = wavread('la.wav');
L = length(DAFx_in);
DAFx_in       = [zeros(WLen, 1); DAFx_in; ...
   zeros(WLen-mod(L,n1),1)] / max(abs(DAFx_in));
%----- initializations -----
DAFx_out = zeros(length(DAFx_in),1);
tic
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
pin  = 0;
pout = 0;
pend = length(DAFx_in) - WLen;

while pin<pend
	grain = DAFx_in(pin+1:pin+WLen).* w1;
%===========================================
	f     = fft(fftshift(grain));
	r     = abs(f);
	phi   = angle(f);
	ft    = (r.* exp(i*phi));
	grain = fftshift(real(ifft(ft))).*w2;
% ===========================================
	DAFx_out(pout+1:pout+WLen) = ...
	   DAFx_out(pout+1:pout+WLen) + grain;
	pin  = pin + n1;
	pout = pout + n2;
end
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
toc
%----- listening and saving the output -----
%DAFx_in  = DAFx_in(WLen+1:WLen+L);
DAFx_out = DAFx_out(WLen+1:WLen+L) / max(abs(DAFx_out));
soundsc(DAFx_out, FS);
wavwrite(DAFx_out, FS, 'la_pv_nothing.wav');