% VX_pitch_pv.m
%===== this program performs pitch shifting 
%===== using the FFT/IFFT approach
%===== w1 and w2: windows (analysis and synthesis)
%===== WLen: is the length of the windows
%===== n1 and n2: steps (in samples) for the analysis and synthesis

clear; clf

n1             = 500;
n2             = 512;
tstretch_ratio = n2/n1;
WLen           = 2048;
w1             = hanningz(WLen);
w2             = w1;
[DAFx_in, FS]  = wavread('flute2');
L              = length(DAFx_in);
DAFx_in        = [zeros(WLen, 1); DAFx_in; ...
   zeros(WLen-mod(L,n1),1)] / max(abs(DAFx_in));


%----- for linear interpolation of a grain of length WLen -----
lx  = floor(WLen*n1/n2);
x   = 1+(0:lx-1)'*WLen/lx;
ix  = floor(x);
ix1 = ix+1;
dx  = x-ix;
dx1 = 1-dx;

%----- initializations -----
DAFx_out = zeros(lx+length(DAFx_in),1);
omega    = 2*pi*n1*[0:WLen-1]'/WLen;
phi0     = zeros(WLen,1);
psi      = zeros(WLen,1);

tic
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
pin  = 0;
pout = 0;
pend = length(DAFx_in)-WLen;

while pin<pend
	grain = DAFx_in(pin+1:pin+WLen).* w1;
%===========================================
	f     = fft(fftshift(grain));
	r     = abs(f);
	phi   = angle(f);

	delta_phi = omega + princarg(phi-phi0-omega);
	phi0  = phi;
	psi   = princarg(psi+delta_phi*tstretch_ratio);

	ft    = (r.* exp(i*psi));
	grain = fftshift(real(ifft(ft))).*w2;
		
	%----- interpolation -----
	grain2 = [grain;0];
	grain3 = grain2(ix).*dx1+grain2(ix1).*dx;
%	plot(grain);drawnow;
% ===========================================
	DAFx_out(pout+1:pout+lx) = DAFx_out(pout+1:pout+lx) + grain3;
	pin    = pin + n1;
	pout   = pout + n1;
	end
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
toc

%----- listening and saving the output -----
%DAFx_in  = DAFx_in(WLen+1:WLen+L);
DAFx_out = DAFx_out(WLen+1:WLen+L) / max(abs(DAFx_out));
soundsc(DAFx_out, FS);
wavwrite(DAFx_out, FS, 'flute2_pitch_pv.wav');