% VX_pitch_bank.m
%===== this program performs pitch shifting 
%===== using the oscillator bank approach, with:
%===== w1 and w2: windows (analysis and synthesis)
%===== WLen: is the length of the windows
%===== n1: step (in samples) for the analysis and synthesis
%===== pit_ratio: pitch shifting ratio

clear; clf

%----- user data -----
n1           = 512;
pit_ratio    = 1.2
WLen         = 2048;
w1           = hanningz(WLen);
w2           = w1;
[DAFx_in, FS] = wavread('la.wav');
L             = length(DAFx_in);
DAFx_in       = [zeros(WLen, 1); DAFx_in; ...
   zeros(WLen-mod(L,n1),1)] / max(abs(DAFx_in));

%----- initializations -----
DAFx_out = zeros(length(DAFx_in),1);
grain    = zeros(WLen,1);
ll       = WLen/2;
omega    = 2*pi*n1*[0:ll-1]'/WLen;
phi0     = zeros(ll,1);
r0       = zeros(ll,1);
psi      = phi0;
res      = zeros(n1,1);

tic
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
pin  = 0;
pout = 0;
pend = length(DAFx_in)-WLen;

while pin<pend
	grain = DAFx_in(pin+1:pin+WLen).* w1;
%===========================================
	fc  = fft(fftshift(grain));
	f   = fc(1:ll);
	r   = abs(f);
	phi = angle(f);
	delta_phi = omega + princarg(phi-phi0-omega);
	delta_r   = (r-r0)/n1;
	delta_psi = pit_ratio*delta_phi/n1;
	for k=1:n1
		r0     = r0+delta_r;
		psi    = psi+delta_psi;
		res(k) = r0'*cos(psi);
	end
%	plot(res);pause;
	phi0 = phi;
	r0   = r;
	psi  = princarg(psi);
% ===========================================
	DAFx_out(pout+1:pout+n1) = DAFx_out(pout+1:pout+n1) + res;
	pin  = pin + n1;
	pout = pout + n1;
	end
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
toc

%----- listening and saving the output -----
%DAFx_in = DAFx_in(WLen+1:WLen+L);
DAFx_out = DAFx_out(WLen/2+n1+1:WLen/2+n1+L) / max(abs(DAFx_out));
soundsc(DAFx_out, FS);
wavwrite(DAFx_out, FS, 'la_pitch_bank.wav');