% VX_het_nothing.m
clear; clf
%===== this program implements a heterodyne filter bank
%===== then filters a sound through the filter bank 
%===== and reconstructs a sound

%----- user data -----
WLen          = 256;
nChannel      = 128;  % nb of channels
n1            = 1024; % block size for calculation 
                      % (must be a multiple of WLen)
[DAFx_in, FS] = wavread('la.wav');
L             = length(DAFx_in);
DAFx_in       = [DAFx_in; zeros(n1,1)] / max(abs(DAFx_in));

%----- window and arrays -----
window   = hanningz(WLen);
DAFx_out = zeros(length(DAFx_in),1);
X        = zeros(n1, nChannel);
z        = zeros(WLen-1, nChannel);

%----- initialization of the filters -----
t   = (0:n1-1)';
het = zeros(n1,nChannel);
for k=1:nChannel
	wk        = 2*pi*i*(k/WLen);
	het(:,k)  = exp(wk*(t+WLen/2));
	het2(:,k) = exp(-wk*t);
end

%colormap(gray); imagesc(angle(het)'); axis('xy'); pause;

tic
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
p    = 0;
pend = length(DAFx_in) - n1;
while p<pend
	p
	grain = DAFx_in(p+1:p+n1);
%===========================================
    %----- filtering -----
	for k=1:nChannel
		[X(:,k), z(:,k)] = filter(window, 1, grain.*het(:,k), z(:,k));
	end
	X_tilde = X.*het2;
    %----- drawing -----
%	imagesc(angle(X_tilde')); axis('xy'); drawnow
    %----- reconstruction -----
	res = real(sum(X_tilde,2));
%===========================================
	DAFx_out(p+1:p+n1) = res;
	p = p + n1;
	end
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
toc

%----- listening and saving the output -----
DAFx_out = DAFx_out(nChannel+1:nChannel+L) / max(abs(DAFx_out));
soundsc(DAFx_out,FS);
wavwrite(DAFx_out, FS, 'la_het_nothing.wav');