% VX_gab_nothing.m
%= this program performs the convolution of the signal with gaborets
clear; clf
%----- user data -----
WLen  = 512;
window        = hanningz(WLen);
nChannel      = WLen/2;
n1            = 128;
n2            = n1;
[DAFx_in, FS] = wavread('la.wav');
L             = length(DAFx_in);
DAFx_in       = [zeros(WLen, 1); DAFx_in; ...
   zeros(WLen-mod(L,n1),1)] / max(abs(DAFx_in));

DAFx_out = zeros(length(DAFx_in),1);
%----- initializations calculation of gaborets -----
t   = (-WLen/2:WLen/2-1);
gab = zeros(nChannel,WLen);
for k=1:nChannel
	wk       = 2*pi*i*(k/WLen);
	gab(k,:) = window'.*exp(wk*t);
end

tic
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
pin  = 0;
pout = 0;
pend = length(DAFx_in) - WLen;

while pin<pend
	grain = DAFx_in(pin+1:pin+WLen);
%===========================================
    %----- complex vector corresponding to a vertical line		
	vec = gab*grain;
    %----- reconstruction from the vector to a grain
	res = real(gab'*vec);
% ===========================================
	DAFx_out(pout+1:pout+WLen) = DAFx_out(pout+1:pout+WLen) + res;
	pin  = pin + n1;
	pout = pout + n2;
	end
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
toc

%----- listening and saving the output -----
%DAFx_in  = DAFx_in(WLen+1:WLen+L);
DAFx_out = DAFx_out(WLen+1:WLen+L) / max(abs(DAFx_out));
soundsc(DAFx_out, FS);
wavwrite(DAFx_out, FS, 'la_gab_nothing.wav');