% VX_filter_nothing.m
clear; clf
%===== this program performs a complex-valued filter bank
%===== then filters a sound through the filter bank 
%===== and reconstructs a sound

%----- user data -----
WLen          = 256;
nChannel      = 128;  % nb of channels
n1            = 1024; % block size for calculation
[DAFx_in, FS] = wavread('la.wav');
L             = length(DAFx_in);
DAFx_in       = [DAFx_in; zeros(n1,1)] / max(abs(DAFx_in));

%----- window and arrays -----
window   = hanningz(WLen);
DAFx_out = zeros(length(DAFx_in),1);
X_tilde  = zeros(n1,nChannel);
z        = zeros(WLen-1,nChannel);

%----- initialisation of the filters -----
t         = (-WLen/2:WLen/2-1)';
ourFilter = zeros(WLen, nChannel);
for k=1:nChannel
	wk             = 2*pi*i*(k/WLen);
	ourFilter(:,k) = window.*exp(wk*t);
end

%colormap(gray)

tic
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
p    = 0;
pend = length(DAFx_in) - n1;
while p<pend
	p
	grain = DAFx_in(p+1:p+n1);
%===========================================
    %----- filtering -----
	for k=1:nChannel
		[X_tilde(:,k),z(:,k)]=filter(ourFilter(:,k),1,grain,z(:,k));
	end
    %----- drawing -----
%	imagesc(angle(X_tilde')); axis('xy'); drawnow;
    %----- reconstruction -----
	res = real(sum(X_tilde,2));
%===========================================
	DAFx_out(p+1:p+n1) = res;
	p = p + n1;
	end
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
toc

%----- listening and saving the output -----
DAFx_out = DAFx_out(nChannel+1:nChannel+L) / max(abs(DAFx_out));
soundsc(DAFx_out, FS);
wavwrite(DAFx_out, FS, 'la_filter_nothing.wav');