% VX_filter.m
%===== this program performs time-frequency filtering
%===== calculation of the fir (here band pass)

clear; clf

%----- user data -----
FirLength     = 1280;        % length of the fir
WLen          = 2*FirLength; % for zero padding
[DAFx_in, FS] = wavread('la.wav');
L             = length(DAFx_in);
DAFx_in       = [DAFx_in;  zeros(WLen-mod(L,FirLength),1)] ...
   / max(abs(DAFx_in));

%----- initializations -----
x             = 1:FirLength;
fr            = 1000/FS;
alpha         = -0.002;
fir           = (exp(alpha*x).*sin(2*pi*fr*x))'; % FIR coefficients 
plot(fir);

fir2          = [fir; zeros(WLen-FirLength,1)];
fcorr         = fft(fir2);
DAFx_out      = zeros(length(DAFx_in)+FirLength,1);
grain         = zeros(WLen,1);

tic
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
pin  = 0;
pout = 0;
pend = length(DAFx_in) - FirLength;

while pin<pend
	grain = [DAFx_in(pin+1:pin+FirLength); zeros(FirLength,1)];	
%===========================================
	ft    = fft(grain) .* fcorr;
	grain = (real(ifft(ft)));
%===========================================
	DAFx_out(pin+1:pin+WLen) = ...
	   DAFx_out(pin+1:pin+WLen) + grain;
	pin   = pin + FirLength;	
end
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
toc

%----- listening and saving the output -----
%DAFx_in  = DAFx_in(WLen+1:WLen+L);
DAFx_out = DAFx_out / max(abs(DAFx_out));
soundsc(DAFx_out, FS);
wavwrite(DAFx_out, FS, 'la_filter.wav');