% VX_bank_nothing.m
%===== this program performs an FFT analysis and 
%===== oscillator bank synthesis, with:
%===== WLen is the length of the windows
%===== n1 and n2: steps (in samples) for the analysis and synthesis
%===== w1 and w2 windows (analysis and synthesis)
clear; clf
%----- user data -----
n1            = 200;
n2            = n1;
WLen          = 2048;
w1            = hanningz(WLen);
w2            = w1;
[DAFx_in, FS] = wavread('la.wav');
L             = length(DAFx_in);
DAFx_in       = [zeros(WLen, 1); DAFx_in; ...
   zeros(WLen-mod(L,n1),1)] / max(abs(DAFx_in));
%----- some initializations -----
DAFx_out = zeros(length(DAFx_in),1);
ll    = WLen/2;
omega = 2*pi*n1*[0:ll-1]'/WLen;
phi0  = zeros(ll,1);
r0    = zeros(ll,1);
psi   = zeros(ll,1);
grain = zeros(WLen,1);
res   = zeros(n2,1);

tic
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
pin  = 0;
pout = 0;
pend = length(DAFx_in) - WLen;

while pin<pend
	grain = DAFx_in(pin+1:pin+WLen).* w1;
%===========================================
	fc  = fft(fftshift(grain));
	f   = fc(1:ll);
	r   = abs(f);
	phi = angle(f);
	delta_phi = omega + princarg(phi-phi0-omega);
    % now we have the unwrapped difference of phase
    % on each bin for the hop size of n2
	delta_r   = (r-r0)/n1;
	delta_psi = delta_phi/n1;
    % and now we have the increment of phase and of magnitude 
    % to make a linear interpolation and reconstruction
	for k=1:n2
		r0     = r0 + delta_r;
		psi    = psi + delta_psi;
		res(k) = r0'*cos(psi);
        % this tricky line is making the sum of weighted cosine
	end
    %----- for next time ------
	phi0 = phi;
	r0   = r;
	psi  = princarg(psi);
% ===========================================
	DAFx_out(pout+1:pout+n2) = DAFx_out(pout+1:pout+n2) + res;
	pin  = pin + n1;
	pout = pout + n2;
	end
%UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
toc

%----- listening and saving the output -----
%DAFx_in = DAFx_in(WLen+1:WLen+L);
DAFx_out = DAFx_out(WLen/2+n1+1:WLen/2+n1+L) / max(abs(DAFx_out));
soundsc(DAFx_out,FS);
wavwrite(DAFx_out, FS, 'la_bank_nothing.wav');