function y=tube(x, gain, Q, dist, rh, rl, mix)
% y=tube(x, gain, Q, dist, rh, rl, mix)
% "Tube distortion" simulation, asymmetrical transfer funktion.
% x    - input
% gain - the amount of distortion, >0->
% Q    - work point. Controls the linearity of the transfer function for 
%	     low input levels, more negative=more linear
% dist - controls the distortion's character, a higher number gives a harder 
%	     distortion, >0
% rh   - abs(rh)<1, but close to 1. The placement of the poles in the HP 
%	     filter which removes the DC component which is introduced by the 
%	     asymmetric transfer function
% rl   - 0<rl<1. The pole placement in the LP filter which is used to 
%	     simulate capasitances in a tube amplifier
% mix  - mix of original and distorted sound, 1=only distorted
% 1997 Copyrights by R. Bendiksen 1
q=x*gain/max(abs(x));			%Normalization
if Q==0
  z=q./(1-exp(-dist*q));
  for i=1:length(q)			%Test because of the
    if q(i)==Q				%transfer function's
      z(i)=1/dist;			%0/0 value in Q
    end;
  end;
else
  z=(q-Q)./(1-exp(-dist*(q-Q)))+Q/(1-exp(dist*Q));
  for i=1:length(q)				%Test because of the
    if q(i)==Q					%transfer function's
      z(i)=1/dist+Q/(1-exp(dist*Q));	%0/0 value in Q
    end;
  end;
end;
y=mix*z*max(abs(x))/max(abs(z))+(1-mix)*x;
y=y*max(abs(x))/max(abs(y));			
y=filter([1 -2 1],[1 -2*rh rh^2],y);	%HP filter
y=filter([1-rl],[1 -rl],y);			    %LP filter
