function y=hard_limiter(x, limit)
% Hard sound limiter, limit	- normalized limit 
g=filter(1e-5*[0.45535887 0.91071773849 0.45535887],...
...[1 -1.99395528   0.993973494],abs(x));
% detects the envelope of the signal with a second order 
% Butterworth filter, cut off frequency 30 Hz
h=h/max(h);
for n=1:length(x)		
  if h(n)>limit			%if the signal envelope is above the limit
    x(n)=x(n)*limit/g(n);	
  end;
end;
y=x;
